#ifndef __SUDOKU_SOLUTION_H__
#define __SUDOKU_SOLUTION_H__
/* This file declares the SudokuSolution class, which is actually just a container
 * for a 9x9 grid of integers.  The purpose of this class is to store a solution to
 * a Sudoku puzzle.
 *
 * Date       User              Note
 * 2009-11-05 Eric Oulashin     Created
 */

class SudokuSolution
{
	public:
		// Constructor - Initializes all puzzle values to 0.
		SudokuSolution();

		// Destructor
		~SudokuSolution();

		// Sets a value in the puzzle.  If either of the row indexes are out,
		// of bounds this function will do nothing.
		//
		// Parameters:
		//  pRow: The row index (0-8)
		//  pCol: The column index (0-8)
		void SetValue(int pRow, int pCol, int pValue);

		// Gets a value from the puzzle.  If either of the row indexes are out,
		// of bounds this function will return -1.
		//
		// Parameters:
		//  pRow: The row index (0-8)
		//  pCol: The column index (0-8)
		//
		// Return value: The value from the puzzle, or -1 if pRow or pCol are out of bounds.
		int GetValue(int pRow, int pCol) const;

	private:
		int mPuzzle[9][9];
};

#endif